---
title: 컨펌 프로세스
description: 결제요청의 주체를 고객사 서버로 가져갈수 있는 서비스입니다.
targetVersions:
  - v1
versionVariants:
  v2: /opi/ko/extra/confirm-process/readme-v2
---

## 해당 서비스는 결제요청직전에 고객사 측에 결제의사를 최종적으로 확인하는 서비스입니다.

![](</gitbook-assets/ko/image (259).png>)

(이미지 첨부: 컨펌 프로세스)

<div class="hint" data-style="info">

**해당 서비스가 반드시 필요한 고객사는 아래와 같은 경우입니다.**

- 판매 제품이 재고적으로 소량인 경우
- 선착순방식으로 결제가 진행되는 경우
- 결제 요청전 마지막으로 고객사에서 처리하고 싶은 업무처리가 있는 경우

</div>

(이미지 첨부: 컨펌 프로세스)

## 판매 제품이 재고적으로 소량인 경우

고객사 판매 제품이 명품 또는 매우 인기가 높은 품목인 경우 결제 시 동시 접속자로 인해 경쟁이
치열해지는 경우 결제 직전 고객사 서버에서 재고수량을 한번더 확인하고 수량이 있는 경우에만 결제가
요청되도록 처리 할 수 있습니다. 만약 컨펌 프로세스를 설정하지 않는 경우 결제는 되었지만 재고가
없어서 제품 발송을 약속된 일자에 처리하지 못하거나 혹은 이로인해 취소처리가 발생하여 고객 결제 만족
경험도를 떨어트리는 상황이 발생됩니다.

![](</gitbook-assets/ko/image (217).png>)

## 선착순 방식으로 결제가 진행되는 경우

마라톤 참가 신청, 인기 콘서트 티켓팅, OO Day 와 같은 특별 할인행사 처럼 특정 시간에 결제가
활성화되는 결제방식을채택하고 있는 고객사인 경우 특정시간에 매우 많은 고객이 동시에 결제 요청이
유입되며 이에따라 결제 요청 직전에 고객사 서버에서 재고수량 파악이 필요합니다.

![](</gitbook-assets/ko/image (164).png>)

## 결제 직전 고객사에서 업무로직을 한번 더 수행하고 싶은 경우

이밖에 다른 사유로 고객사 측에서 결제 직전 자체업무 처리가 필요한 경우(결제 직전 고객사 서버 헬스체크 등) 해당 서비스를 이용합니다.

![](</gitbook-assets/ko/image (262).png>)

<div class="hint" data-style="info">

**컨펌 프로세스 신청 방법**

기술지원 메일(<tech.support@portone.io>)로 **고객사 식별코드**를 기재하여 메일 발송

(이미지 첨부: 포트원 콘솔 내 고객사 식별코드 확인 예시)

포트원 콘솔 로그인 후 \[결제연동] → \[식별코드 ・ API Keys] → \[V1 API] 페이지에서 확인할 수 있습니다.

</div>

## 컨펌 프로세스 이용방법

컨펌 프로세스 이용시 고객사는 Javascript request\_pay() 함수 호출시 **confirm\_url** 파라미터를
정의하고 해당 파라미터의 고객사 EndPoint URL을 설정합니다.

```json title="JavaScript SDK"
{
  //...중략
  "confirm_url": "고객사 EndPoint URL 기재"
  //...중략
}
```

해당 URL이 설정되면 당사에서 결제 요청 직전 해당 URL 로 **HTTP 통신**이 진행되며 아래와 같은 Data가 POST로 요청됩니다. (Timeout : **10s**)

> `imp_uid`: 결제번호
>
> `merchant_uid`: 주문번호
>
> `amount`: 결제 금액

해당 요청에 대한 고객사 응답으로 HTTP Status **200** 응답을 주시는 경우 결제를 요청합니다.

(**200응답이 아닌 경우 결제가 진행되지 않습니다**.(**`실패처리`**)

**200** 외 응답을 통해 승인을 막음과 동시에 해당 사유를 함께 기록하고싶으실 경우 요청 응답 body에 `reason` 파라미터를 json 형태로 전달해주시면 되며

```json
{
  "reason": "재고 부족"
}
```

전달주신 `reason` 값이 `고객사 요청에 의해 결제를 중단합니다. (상세사유 : %s)`의 상세사유에 추가되어
결제 실패 사유(fail\_reason)으로 기록됩니다. (기본값 : `알 수 없음`)
