---
title: 연동 유의사항
description: 토스페이먼츠 브랜드페이 연동 유의사항을 소개합니다.
targetVersions:
  - v1
---

## 카드 결제

### 고정 할부 개월 수 결제

- 포트원을 통해 다른 결제대행사(PG)를 이용하는 경우 `display.card_quota` 파라미터에 할부 개월 수를
  입력하여 결제 요청을 하면, 구매자에게 노출할 할부 개월 수 정보를 리스트로 제어가 가능합니다.

- 하지만 포트원을 통해 브랜드페이를 이용하는 경우 해당 파라미터 값을 입력 후 결제 요청 시 입력한
  할부 개월 수로 결제가 진행됩니다.

<details>

<summary>파라미터 사용 예시</summary>

- 예1. 6개월 할부로 결제를 하고자 하는 경우

```json
{
  "display": {
    "card_quota": [6]
  },
  "bypass": {
    "toss_brandpay": {
      "methodId": "c_j429K3djbS01dlk" // 브랜드페이에 등록된 결제 수단의 ID
    }
  }
}
```

</details>

## 현금영수증 유의사항

### 소득공제용 자진발급

- 결제창 내에서 현금영수증 미발행을 선택한 후 결제 승인이 되면 현금영수증이 소득공제용 자진발급으로
  발급됩니다.

- 브랜드페이 결제 요청 시 `methodId` 와 함께 `bypass.cashReceiptType`을 `anonymous`로 입력한 후 결제
  요청 및 승인이 완료되면 현금영수증이 소득공제용 자진발급으로 발급됩니다.

<details>

<summary>파라미터 사용 예시</summary>

```json
{
  "bypass": {
    "cashReceiptType": "anonymous",
    "toss_brandpay": {
      "methodId": "c_j429K3djbS01dlk" // 브랜드페이에 등록된 결제 수단의 ID
    }
  }
}
```

</details>

## 취소관련 유의사항

### 잔여 면세금액 계산

- 부분 취소 및 전체 취소시, 남은 면세 금액을 정확하게 계산하여 요청해야합니다.

## 테스트 관련 유의사항

### 더미 데이터 리턴

- 브랜드페이의 경우 토스페이먼츠의 정책상 테스트 환경의 API 키를 이용하여 결제 요청 및 승인을 하면 더미 데이터 값이 리턴됩니다.
- 연동 후 정상적인 데이터를 확인하기 위해서는 브랜드페이의 라이브 API 키를 이용해서 결제 요청 및 승인을 진행해야 합니다.

### 토스페이먼츠 제공 API 사용

- 결제 취소를 제외한 현금영수증 발급 API 및 결제조회 API는 토스페이먼츠에서 제공하는 API를 이용해야 합니다.
