---
title: 대표상점과 하위상점
description: 대표상점과 하위상점 설정에 대한 안내 입니다.
targetVersions:
  - v1
---

**하나의 계정으로 하위 상점별 결제대행사 이용을 원하시는 경우 포트원에서 제공하는 하위상점 기능을 사용하시면 됩니다.**

회원가입 시 대표상점이 자동으로 생성되며, 추가로 하위상점을 추가하여 하위 상점별 결제대행사 채널 등록 및 결제내역 조회(취소)가 가능합니다.
하위 상점 생성 시 `Tier Code`(영문, 숫자를 조합한 3자리 고유 코드를 지정) 이용하여 결제를 진행해야 합니다.

하위상점 생성은 포트원 콘솔 내 [하위 상점 관리](https://admin.portone.io/merchant/?tab=store)에서 생성할 수 있습니다.

## 주요 기능

**1. 하위몰별 결제대행사 채널 설정**

- 하위 상점을 추가 혹은 삭제하고, 하위 상점의 PG사 MID 설정 및 관리를 하실 수 있습니다.
- 하위 상점은 대표 상점에 추가된 채널에 한해서만 선택하여 추가할 수 있습니다.

(이미지 첨부: 하위 상점 생성 예시 화면 1)

(이미지 첨부: 하위 상점 생성 예시 화면 2)

**2. 결제 요청**

<div class="hint" data-style="info">

포트원 V1 결제 모듈의 경우 아래 방법으로 결제를 요청해야 합니다.
포트원 V2 결제 모듈의 경우 하위 상점 생성 시 채번되는 store id를 이용하여 대표상점과 동일하게 결제 요청/조회/취소를 진행할 수 있습니다.

</div>

- 하위 상점 결제요청시 **JavaScript SDK** 에서 다음과 같이 **Tier를 구분하여 호출**하실 수 있습니다.

**IMP.agency(고객사 식별코드, Tier(고유)코드 3자리)**

`ex) IMP.agency('imp12345678', '001')`

<div class="hint" data-style="info">

**REST API호출시 주의 사항**

REST API호출시에는 Header에 Tier정보를 같이 보내야 해당 Tier에 대한 접근이 가능

HTTP Header 에 아래와 같은 파라미터 설정 필요

`"Tier" : "티어코드 3자리"`

</div>
